import json
import openai

# Load graph
with open("graph_async_with_decay.json", "r") as f:
    graph = json.load(f)

# OpenAI API key setup
openai.api_key = "sk-..."  # Replace with your key

def get_neighbors(node):
    """Returns (relation, object) pairs"""
    return graph.get(node.lower(), [])

def formulate_prompt(node, hops=1):
    """Traverse up to 'hops' level and make a natural language description"""
    visited = set()
    queue = [(node, 0)]
    facts = []

    while queue:
        current_node, depth = queue.pop(0)
        if current_node in visited or depth > hops:
            continue
        visited.add(current_node)
        neighbors = get_neighbors(current_node)
        for relation, obj in neighbors:
            facts.append(f'"{current_node}" {relation} "{obj}"')
            queue.append((obj, depth + 1))
    
    prompt = f"Given the following facts extracted from a knowledge graph:\n" + "\n".join(facts) + \
             f"\n\nPlease answer: What can we infer about '{node}'? Summarize it concisely."

    return prompt

def ask_gpt(prompt):
    """Simple OpenAI API call"""
    response = openai.ChatCompletion.create(
        model="gpt-4o",
        messages=[{"role": "user", "content": prompt}],
        temperature=0.5,
        max_tokens=500
    )
    return response['choices'][0]['message']['content'].strip()

# Example usage
node = "stephen king"
prompt = formulate_prompt(node, hops=2)
print("Prompt to GPT:\n", prompt)
print("\nGPT Answer:\n", ask_gpt(prompt))
